import 'dart:html';

import 'package:rad/rad.dart';
import 'package:rad/widgets_html.dart';

import 'package:photogram_admin_cp/import/bloc.dart';
import 'package:photogram_admin_cp/import/core.dart';
import 'package:photogram_admin_cp/import/data.dart';

class LoginScreen extends StatefulWidget {
  const LoginScreen({Key? key}) : super(key: key);

  @override
  State<StatefulWidget> createState() => _LoginScreenState();
}

class _LoginScreenState extends State<LoginScreen> {
  var _isFormSubmitInProgress = false;
  var _formSubmitError = '';

  @override
  build(context) {
    return Division(
      className: 'page-wrapper animate__animated animate__fadeIn',
      children: [
        const Division(className: 'sticky-alerts'),
        Division(
          className: 'content-wrapper',
          children: [
            Division(
              className: 'h-full d-flex justify-content-center align-items-center',
              children: [
                Division(
                  className: 'w-400',
                  children: [
                    Division(
                      className: 'card p-0',
                      children: [
                        const Division(
                          className: 'px-card py-10 border-bottom',
                          children: [
                            Heading2(
                              className: 'card-title font-size-14 m-0',
                              innerText: 'Sign In',
                            ),
                          ],
                        ),
                        Form(
                          onSubmit: _onFormSubmit,
                          children: [
                            FieldSet(
                              className: 'px-card py-20',
                              children: [
                                const Division(
                                  className: 'form-group',
                                  children: [
                                    Division(
                                      children: [
                                        Label(
                                          forAttribute: AdminTable.username,
                                          className: 'required',
                                          innerText: 'Username',
                                        ),
                                        InputText(
                                          id: AdminTable.username,
                                          name: AdminTable.username,
                                          value: '',
                                          placeholder: 'Username',
                                          className: 'form-control',
                                          required: true,
                                        ),
                                      ],
                                    ),
                                    LineBreak(),
                                    Division(
                                      children: [
                                        Label(
                                          forAttribute: AdminTable.password,
                                          className: 'required',
                                          innerText: 'Password',
                                        ),
                                        InputPassword(
                                          id: AdminTable.password,
                                          name: AdminTable.password,
                                          value: '',
                                          placeholder: 'Password',
                                          className: 'form-control',
                                          required: true,
                                        ),
                                      ],
                                    ),
                                  ],
                                ),
                                if (!_isFormSubmitInProgress && _formSubmitError.isNotEmpty)
                                  Division(
                                    className: 'alert alert-secondary my-10',
                                    innerText: _formSubmitError,
                                  ),
                                const LineBreak(),
                                InputSubmit(
                                  className: 'btn btn-primary btn-block',
                                  value: _isFormSubmitInProgress ? 'Signing in...' : 'Sign In',
                                  disabled: _isFormSubmitInProgress,
                                ),
                              ],
                            ),
                          ],
                        ),
                        const Division(
                          className: 'px-card py-10 bg-light-lm bg-very-dark-dm rounded-bottom',
                          children: [
                            Paragraph(
                              className: 'font-size-12, m-0',
                              innerText: 'Sign into your Account.',
                            )
                          ],
                        ),
                      ],
                    ),
                  ],
                )
              ],
            ),
          ],
        )
      ],
    );
  }

  void _onFormSubmit(EmittedEvent event) async {
    event.preventDefault();

    if (_isFormSubmitInProgress) return;

    setState(() {
      _isFormSubmitInProgress = true;
    });

    try {
      var form = event.target as FormElement;

      var formData = FormData(form);

      var username = formData.get(AdminTable.username);
      var password = formData.get(AdminTable.password);

      var responseModel = await AppProvider.of(context).apiRepo.preparedRequest(
        requestType: REQ_TYPE_ADMIN_LOGIN,
        requestData: {
          AdminTable.tableName: {
            AdminTable.username: username,
            AdminTable.password: password,
          }
        },
      );

      switch (responseModel.message) {
        case D_ERROR_ADMIN_NOT_MATCHED_MSG:
          _formSubmitError = 'Username or Password is incorrect';
          break;

        case SUCCESS_MSG:
          if (!responseModel.contains(AdminTable.tableName)) throw Exception();

          var authedAdmin = AdminModel.fromJson(responseModel.first(AdminTable.tableName));

          if (authedAdmin.isNotModel) throw Exception();

          return AuthBloc.of(context).pushEvent(
            AuthEventPreparing(context, authedAdmin: authedAdmin),
          );

        default:
          _formSubmitError = 'Something went wrong.';
          break;
      }
    } catch (_) {}

    setState(() {
      _isFormSubmitInProgress = false;
    });
  }
}
